/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.inventory.BaseContainerMenu;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.world.TinkerWorld;

@Mod.EventBusSubscriber(modid="tconstruct")
public class CommonsEvents {
    @SubscribeEvent
    static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        BlockState state;
        Block block;
        if (event.getEntity() == null) {
            return;
        }
        BlockPos pos = new BlockPos(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_());
        if (event.getEntity().m_20193_().m_46859_(pos)) {
            pos = pos.m_7495_();
        }
        if (TinkerWorld.congealedSlime.contains((IForgeRegistryEntry)(block = (state = event.getEntity().m_20193_().m_8055_(pos)).m_60734_()))) {
            CommonsEvents.bounce(event.getEntity(), 0.25f);
        } else if (TinkerWorld.slimeDirt.contains((IForgeRegistryEntry)block) || TinkerWorld.vanillaSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.earthSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.skySlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.enderSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.ichorSlimeGrass.contains((IForgeRegistryEntry)block)) {
            CommonsEvents.bounce(event.getEntity(), 0.06f);
        }
    }

    @SubscribeEvent
    static void openSpectatorMenu(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        if (player.m_5833_()) {
            BlockPos pos = event.getPos();
            Level world = event.getWorld();
            BlockState state = world.m_8055_(pos);
            if ("tconstruct".equals(Objects.requireNonNull(state.m_60734_().getRegistryName()).m_135827_())) {
                MenuProvider provider = state.m_60750_(world, pos);
                event.setCanceled(true);
                if (provider != null) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)provider, (BlockPos)pos);
                        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                        if (abstractContainerMenu instanceof BaseContainerMenu) {
                            BaseContainerMenu menu = (BaseContainerMenu)abstractContainerMenu;
                            menu.syncOnOpen(serverPlayer);
                        }
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
                event.setCancellationResult(InteractionResult.PASS);
            }
        }
    }

    private static void bounce(Entity entity, float amount) {
        entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)amount, 0.0));
        entity.m_5496_(Sounds.SLIMY_BOUNCE.getSound(), 0.5f + amount, 1.0f);
    }

    private CommonsEvents() {
    }
}

